#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

class Tile
{
	public:
	int x, y, v;
	Tile()
		:x(0), y(0), v(0) {}
	Tile(int x1, int y1, int v1)
		:x(x1), y(y1), v(v1) {}
	bool operator<(Tile& cmp)
	{
		return (v < cmp.v);	
	}	
};

int main()
{
	ios_base::sync_with_stdio(false);
	cin.tie(0);
	
	int n, m, q;
	cin >> n >> m >> q;
	int s = n*m;
	vector<Tile> mat(n*m);
	for(int i = 0; i < s; ++i)
	{
		mat[i].x = i/m;
		mat[i].y = i%m;
		cin >> mat[i].v;
	}
	
	vector<int> sols;
	while(q > 0)
	{
		int in, j, h, w;
		cin >> in >> j >> h >> w;
		--h+=in;
		--w+=j;
		int cnt = 0;
		int min = 9999999;
		for(int i = 0; i < s; ++i)
		{
			int x = mat[i].x+1;
			int y = mat[i].y+1;
			if(x >= in && y >= j && x <= h && y <= w) continue;
			if(mat[i].v == min) ++cnt;
			else if(mat[i].v < min)
			{
				cnt = 1;
				min = mat[i].v;
			}
		}
		sols.push_back(cnt);
		--q;
	}
	for(int i = 0; i < sols.size(); ++i)
		cout << sols[i] << endl;
	
	return 0;
}